/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Waypoint
**
** DESCRIPTION:	Maintains a list of waypoints 
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef WAYPOINT_H
#define WAYPOINT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"

class CWaypointEditor;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EWaypoint
{
	eWaypoint_None = -1,

	eWaypoint_VillageCenter,
	eWaypoint_Test1,
	eWaypoint_Test2,
	eWaypoint_Test3,
	eWaypoint_RainLift,

	eWaypoint_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWaypoint
{
	friend class CWaypointEditor;

private:

	//class data
	ldwPoint				m_sWaypoint[eWaypoint_NumberOf];

	//class methods
	//setup
	public:		CWaypoint(void);

	// process
	public:		void Load();
	protected:	const bool Save();

	// access
	public:		const ldwPoint Get(const EWaypoint eWaypoint) const { return m_sWaypoint[eWaypoint]; }
	protected:	void Set(const EWaypoint eWaypoint, ldwPoint sPoint) { m_sWaypoint[eWaypoint] = sPoint; }
	public:		const EWaypoint GetNearby(const ldwPoint sPos) const;
	public:		const EWaypoint GetNearest(const ldwPoint sPos) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CWaypoint		Waypoint;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/